#!usr/bin/perl

#Copyright 2017 Christopher Frenz under the Perl Artistic License
#This script allows the user to enter a domain name and TLD as input
#and computes all possible character substitutions that could be used 
#for phishing attacks as per the substitution matrix below. Admins can 
#use the resultant list to enhance their domain blocklists in SPAM and 
#Web filters to better protect their organizations

use strict;
use warnings;
use List::Util qw(sum);
use List::MoreUtils qw(uniq);

my $domain='example'; #enter the domain here
my $TLD='com'; #enter TLD here
my %counts;
$domain=lc($domain);
my @dchars=(split //, $domain);

#Define character substituions 
my @As=('4','o','u');
my @Bs=('d','8','6');
my @Cs=('e');
my @Ds=('b');
my @Es=('c','3','8');
my @Fs=('t');
my @Gs=('q','j','4','p');
my @Hs=('k','n');
my @Is=('l','1');
my @Js=('g');
my @Ks=('h');
my @Ls=('i','1');
my @Ms=('n');
my @Ns=('m','h','r');
my @Os=('0','a');
my @Ps=('q','4','g');
my @Qs=('p','4','g');
my @Rs=('4','n');
my @Ss=('z','5');
my @Ts=('f');
my @Us=('v','w','a');
my @Vs=('u','w');
my @Ws=('u','v');
my @Xs=('v');
my @Ys=('v','q');
my @Zs=('s','2');

my %subs =(
   "a"=>\@As,
   "b"=>\@Bs,
   "c"=>\@Cs,
   "d"=>\@Ds,
   "e"=>\@Es,
   "f"=>\@Fs,
   "g"=>\@Gs,
   "h"=>\@Hs,
   "i"=>\@Is,
   "j"=>\@Js,
   "k"=>\@Ks,
   "l"=>\@Ls,
   "m"=>\@Ms,
   "n"=>\@Ns,
   "o"=>\@Os,
   "p"=>\@Ps,
   "q"=>\@Qs,
   "r"=>\@Rs,
   "s"=>\@Ss,
   "t"=>\@Ts,
   "u"=>\@Us,
   "v"=>\@Vs,
   "w"=>\@Ws,
   "x"=>\@Xs,
   "y"=>\@Ys,
   "z"=>\@Zs,
 );
 
 my $filename="PhishingDomains.txt";
 open(my $fh, '>', $filename) or die "Could not open file $!";

#computes and prints out domain character count statistics
print $fh "Character Composition\n";
my @unique=uniq @dchars;
foreach my $char (split //, $domain) {$counts{$char}++}
foreach my $char(@unique){
  my $count = sum($counts{$char});
  print $fh "$char $count \n";
}

#creates domain names with substitutions
print $fh "\n\n\nSubstitutions by Letter \n";
foreach my $char(@unique){
print $fh "$char \n";
if($counts{$char}!=0){
  my @loc;
  my $i=0;
  while($domain=~/$char/g){
    $loc[$i]=pos($domain)-1;
	#print "$loc[$i] \n";
	$i++;
  }
  foreach my $CurrentLoc(@loc){
    #print "$CurrentLoc \n";
    my @DomainTemp=(split //, $domain);
	foreach my $a(@{$subs{$char}}){
	  #print "$a \n";
	  $DomainTemp[$CurrentLoc]="$a";
	  my $PhishingDomain=join '', @DomainTemp;
	  print $fh "$PhishingDomain" . '.' . "$TLD \n";
	}
   }
}
}
close $fh;
