/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.stinger.rules;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.owasp.stinger.Category;
import org.owasp.stinger.Severity;
import org.owasp.stinger.actions.AbstractAction;
import org.owasp.stinger.rules.CookieRule;
import org.owasp.stinger.rules.Rule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleSet {
    public static final String STINGER_DEFAULT = "STINGER_DEFAULT";
    public static final String STINGER_ALL = "STINGER_ALL";
    private LinkedList excludeSet = new LinkedList();
    private HashMap pRules = new HashMap();
    private HashMap cRules = new HashMap();
    private HashMap regexs = new HashMap();
    private boolean debug = false;

    private Document parseXmlFile(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        if (this.debug) {
            System.out.println("Stinger SVDL: " + string);
        }
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = documentBuilderFactory.newDocumentBuilder().parse(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    private RuleSet() {
    }

    public RuleSet(String string, boolean bl) {
        this.debug = bl;
        this.parseRules(string);
    }

    private String getField(Element element, String string) {
        String string2 = null;
        Node node = null;
        if (element != null && (node = element.getElementsByTagName(string).item(0)).getNodeType() == 1) {
            element = (Element)node;
            string2 = this.getValue(element);
        }
        return string2;
    }

    private String getValue(Element element) {
        return element.getFirstChild().getNodeValue().trim();
    }

    private void parseParameters(Element element, AbstractAction abstractAction) {
        NodeList nodeList = null;
        Node node = null;
        Element element2 = null;
        String string = null;
        String string2 = null;
        nodeList = element.getElementsByTagName("parameter");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            string = this.getField(element2, "name");
            string2 = this.getField(element2, "value");
            abstractAction.setParameter(string, string2);
        }
    }

    private void parseActions(Element element, Rule rule, Category category) {
        NodeList nodeList = null;
        String string = null;
        Class<?> clazz = null;
        Object var7_7 = null;
        AbstractAction abstractAction = null;
        Node node = null;
        Element element2 = null;
        nodeList = element.getElementsByTagName("action");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            try {
                string = element2.getAttribute("class");
                clazz = Class.forName(string);
                var7_7 = clazz.newInstance();
                if (!(var7_7 instanceof AbstractAction)) continue;
                abstractAction = var7_7;
                this.parseParameters(element2, abstractAction);
                category.addAction(abstractAction);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                continue;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private void parseMissing(Element element, Rule rule) {
        Element element2 = (Element)element.getElementsByTagName("missing").item(0);
        String string = null;
        Category category = null;
        string = this.getField(element2, "severity");
        category = new Category("MISSING", Severity.valueOf(string));
        this.parseActions(element2, rule, category);
        rule.setMissing(category);
    }

    private void parseMalformed(Element element, Rule rule) {
        Element element2 = (Element)element.getElementsByTagName("malformed").item(0);
        String string = null;
        Category category = null;
        string = this.getField(element2, "severity");
        category = new Category("MALFORMED", Severity.valueOf(string));
        this.parseActions(element2, rule, category);
        rule.setMalformed(category);
    }

    private Pattern getPath(Element element) {
        String string = this.getField(element, "path");
        Pattern pattern = Pattern.compile(string);
        return pattern;
    }

    private void parseRules(String string) {
        int n;
        int n2;
        Object object;
        Document document = this.parseXmlFile(string);
        if (this.debug) {
            System.out.println(string);
        }
        Element element = document.getDocumentElement();
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        Element element5 = null;
        NodeList nodeList = null;
        NodeList nodeList2 = null;
        NodeList nodeList3 = null;
        Node node = null;
        String string2 = null;
        String string3 = null;
        Rule rule = null;
        CookieRule cookieRule = null;
        Pattern pattern = null;
        if (element.getElementsByTagName("exclude-set").getLength() > 0) {
            Element element6 = (Element)element.getElementsByTagName("exclude-set").item(0);
            object = element6.getElementsByTagName("exclude");
            for (n2 = 0; n2 < object.getLength(); ++n2) {
                Node node2 = object.item(n2);
                if (node2.getNodeType() != 1) continue;
                Element element7 = (Element)node2;
                String string4 = this.getValue(element7);
                Pattern pattern2 = Pattern.compile(string4);
                this.excludeSet.add(pattern2);
            }
        }
        element2 = (Element)element.getElementsByTagName("regexset").item(0);
        nodeList = element2.getElementsByTagName("regex");
        for (n = 0; n < nodeList.getLength(); ++n) {
            node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            element3 = (Element)node;
            string2 = this.getField(element3, "name");
            string3 = this.getField(element3, "pattern");
            this.regexs.put(string2, string3);
        }
        nodeList2 = element.getElementsByTagName("cookie");
        for (n = 0; n < nodeList2.getLength(); ++n) {
            node = nodeList2.item(n);
            if (node.getNodeType() != 1) continue;
            element4 = (Element)node;
            cookieRule = new CookieRule();
            cookieRule.setName(this.getField(element4, "name"));
            cookieRule.setPattern((String)this.regexs.get(this.getField(element4, "regex")));
            cookieRule.setCreated(this.getField(element4, "created"));
            cookieRule.setEnforced(this.getField(element4, "enforce"));
            this.parseMissing(element4, cookieRule);
            this.parseMalformed(element4, cookieRule);
            this.cRules.put(cookieRule.getName(), cookieRule);
        }
        nodeList3 = element.getElementsByTagName("ruleset");
        for (n = 0; n < nodeList3.getLength(); ++n) {
            node = nodeList3.item(n);
            if (node.getNodeType() != 1) continue;
            element5 = (Element)node;
            pattern = this.getPath(element5);
            object = new HashMap();
            nodeList = element5.getElementsByTagName("rule");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                node = nodeList.item(n2);
                if (node.getNodeType() != 1) continue;
                element3 = (Element)node;
                rule = new Rule();
                rule.setName(this.getField(element3, "name"));
                string3 = (String)this.regexs.get(this.getField(element3, "regex"));
                if (string3 == null) {
                    string3 = this.getField(element3, "regex");
                }
                rule.setPattern(string3);
                this.parseMissing(element3, rule);
                this.parseMalformed(element3, rule);
                ((HashMap)object).put(rule.getName(), rule);
            }
            this.pRules.put(pattern, object);
        }
    }

    public Rule getParameterRule(String string, String string2) {
        Rule rule = null;
        HashMap hashMap = null;
        hashMap = this.getRules(string);
        if (hashMap == null) {
            if (this.debug) {
                System.out.println("[Stinger-Filter](Warning): using default parameter rule for parameter " + string2);
            }
            hashMap = this.getRules(STINGER_DEFAULT);
            rule = (Rule)hashMap.get(STINGER_ALL);
        } else {
            rule = (Rule)hashMap.get(string2);
            if (rule == null && (rule = (Rule)hashMap.get(STINGER_ALL)) == null) {
                hashMap = this.getRules(STINGER_DEFAULT);
                rule = (Rule)hashMap.get(STINGER_ALL);
            }
        }
        return rule;
    }

    public HashMap getRules(String string) {
        HashMap hashMap = null;
        Enumeration enumeration = Collections.enumeration(this.pRules.keySet());
        while (enumeration.hasMoreElements()) {
            Pattern pattern = (Pattern)enumeration.nextElement();
            if (!pattern.matcher(string).matches()) continue;
            hashMap = (HashMap)this.pRules.get(pattern);
        }
        return hashMap;
    }

    public LinkedList getParameterRules(String string) {
        LinkedList<Rule> linkedList = null;
        Iterator iterator = null;
        HashMap hashMap = null;
        String string2 = null;
        Rule rule = null;
        hashMap = this.getRules(string);
        linkedList = new LinkedList<Rule>();
        if (hashMap != null) {
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                rule = (Rule)hashMap.get(string2);
                linkedList.add(rule);
            }
        } else {
            if (this.debug) {
                System.out.println("[Stinger-Filter](WARNING): using default rules for uri " + string);
            }
            hashMap = this.getRules(STINGER_DEFAULT);
            linkedList.add((Rule)hashMap.get(STINGER_ALL));
        }
        return linkedList;
    }

    public CookieRule getCookieRule(String string) {
        return (CookieRule)this.cRules.get(string);
    }

    public LinkedList getCookieRules() {
        LinkedList linkedList = null;
        Iterator iterator = null;
        String string = null;
        linkedList = new LinkedList();
        iterator = this.cRules.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            linkedList.add(this.cRules.get(string));
        }
        return linkedList;
    }

    public HashMap getRegexs() {
        return this.regexs;
    }

    public void addParameterRule(String string, Rule rule) {
        Enumeration enumeration = Collections.enumeration(this.pRules.keySet());
        boolean bl = false;
        HashMap hashMap = null;
        while (enumeration.hasMoreElements()) {
            Pattern pattern = (Pattern)enumeration.nextElement();
            if (!pattern.matcher(string).matches()) continue;
            hashMap = (HashMap)this.pRules.get(pattern);
            hashMap.put(rule.getName(), rule);
            bl = true;
        }
        if (!bl) {
            hashMap = new HashMap();
            hashMap.put(rule.getName(), rule);
            this.pRules.put(Pattern.compile(string), hashMap);
        }
    }

    public HashMap getParameterRules() {
        return this.pRules;
    }

    public boolean isExcluded(String string) {
        Iterator iterator = this.excludeSet.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Pattern pattern = (Pattern)iterator.next();
            if (!pattern.matcher(string).matches()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

