/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.stinger;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.stinger.BreakChainException;
import org.owasp.stinger.Stinger;
import org.owasp.stinger.http.MutableHttpRequest;
import org.owasp.stinger.rules.RuleSet;

public class StingerFilter
implements Filter {
    private Stinger stinger = null;
    private String config = null;
    private boolean reload = false;
    private RuleSet ruleSet = null;
    private String errorPage = null;
    public boolean debug = false;

    public void init(FilterConfig filterConfig) {
        System.out.println("Initializing Stinger");
        this.debug = Boolean.valueOf(filterConfig.getInitParameter("debug"));
        System.out.println("Debugging set to " + String.valueOf(this.debug));
        this.config = filterConfig.getInitParameter("config");
        this.ruleSet = new RuleSet(this.config, this.debug);
        this.errorPage = filterConfig.getInitParameter("error-page");
        this.reload = Boolean.valueOf(filterConfig.getInitParameter("reload"));
        if (this.debug) {
            System.out.println("Reload parm is: " + String.valueOf(this.reload));
        }
        this.stinger = Stinger.getInstance(this.ruleSet, this.debug);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        MutableHttpRequest mutableHttpRequest = null;
        HttpServletResponse httpServletResponse = null;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            mutableHttpRequest = new MutableHttpRequest((HttpServletRequest)servletRequest);
            httpServletResponse = (HttpServletResponse)servletResponse;
            if (this.reload) {
                this.initRuleSet();
            }
            try {
                if (!this.ruleSet.isExcluded(mutableHttpRequest.getRequestURI())) {
                    this.stinger.validate(mutableHttpRequest, httpServletResponse);
                }
                if (this.debug) {
                    System.out.println("We're done processing, so do next filter in the chain");
                }
                filterChain.doFilter((ServletRequest)mutableHttpRequest, (ServletResponse)httpServletResponse);
            }
            catch (BreakChainException breakChainException) {
                breakChainException.printStackTrace();
                try {
                    httpServletResponse.sendRedirect(this.errorPage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    httpServletResponse.sendRedirect(this.errorPage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void destroy() {
    }

    private synchronized void initRuleSet() {
        this.ruleSet = new RuleSet(this.config, this.debug);
        Stinger.setRuleSet(this.ruleSet);
    }
}

