/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.stinger;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.owasp.stinger.BreakChainException;
import org.owasp.stinger.Severity;
import org.owasp.stinger.actions.AbstractAction;
import org.owasp.stinger.http.MutableHttpRequest;
import org.owasp.stinger.rules.CookieRule;
import org.owasp.stinger.rules.Rule;
import org.owasp.stinger.rules.RuleSet;
import org.owasp.stinger.violation.Violation;
import org.owasp.stinger.violation.ViolationList;

public class Stinger {
    private static Stinger instance = new Stinger();
    private static RuleSet set = null;
    private static boolean debug = false;

    private Stinger() {
    }

    public static Stinger getInstance(RuleSet ruleSet, boolean bl) {
        Stinger.setRuleSet(ruleSet);
        Stinger.setDebug(bl);
        return instance;
    }

    public static void setRuleSet(RuleSet ruleSet) {
        set = ruleSet;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    private void handleViolationActions(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, Violation violation) throws BreakChainException {
        LinkedList linkedList = null;
        Iterator iterator = null;
        AbstractAction abstractAction = null;
        linkedList = violation.getActions();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            abstractAction = (AbstractAction)iterator.next();
            abstractAction.doAction(violation, mutableHttpRequest, httpServletResponse);
        }
    }

    private void handleViolations(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, ViolationList violationList) throws BreakChainException {
        Iterator iterator = null;
        Violation violation = null;
        iterator = violationList.iterator();
        while (iterator.hasNext()) {
            violation = (Violation)iterator.next();
            if (debug) {
                System.out.println("Handling violation " + violation.toString());
            }
            this.handleViolationActions(mutableHttpRequest, httpServletResponse, violation);
        }
    }

    private void checkMissingCookies(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, ViolationList violationList) throws BreakChainException {
        String string = mutableHttpRequest.getRequestURI();
        String string2 = null;
        Cookie[] cookieArray = null;
        CookieRule cookieRule = null;
        HashMap<String, Cookie> hashMap = null;
        LinkedList linkedList = null;
        Iterator iterator = null;
        Violation violation = null;
        cookieArray = mutableHttpRequest.getCookies();
        hashMap = new HashMap<String, Cookie>();
        linkedList = set.getCookieRules();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                hashMap.put(cookieArray[i].getName(), cookieArray[i]);
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                cookieRule = (CookieRule)iterator.next();
                if (hashMap.containsKey(cookieRule.getName()) || cookieRule.isCreatedUri(string) || !cookieRule.isEnforced(string)) continue;
                violation = new Violation(cookieRule.getMissing(), string2, null, cookieRule.getPattern(), string);
                if (debug) {
                    System.out.println("[Stinger-Filter] VIOLATION: Cookie " + cookieRule.getName() + " is missing");
                }
                if (violation.getSeverity().equals(Severity.FATAL)) {
                    this.handleViolationActions(mutableHttpRequest, httpServletResponse, violation);
                    throw new BreakChainException("Chain broken due to fatal violation");
                }
                if (!violation.getSeverity().equals(Severity.CONTINUE)) continue;
                violationList.add(violation);
            }
        } else if (debug) {
            System.out.println("[Stinger-Filter] Warning: There exists no cookie rules");
        }
    }

    private void checkMalformedCookies(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, ViolationList violationList) throws BreakChainException {
        String string = null;
        String string2 = null;
        Cookie cookie = null;
        Cookie[] cookieArray = null;
        CookieRule cookieRule = null;
        Violation violation = null;
        string = mutableHttpRequest.getRequestURI();
        cookieArray = mutableHttpRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                cookie = cookieArray[i];
                cookieRule = set.getCookieRule(cookie.getName());
                if (cookieRule == null || !cookieRule.isEnforced(string) || cookieRule.isValid(cookie.getValue())) continue;
                violation = new Violation(cookieRule.getMissing(), string2, cookie.getValue(), cookieRule.getPattern(), string);
                if (debug) {
                    System.out.println("[Stinger-Filter] VIOLATION: Cookie " + cookieRule.getName() + " is malformed");
                }
                if (violation.getSeverity().equals(Severity.FATAL)) {
                    this.handleViolationActions(mutableHttpRequest, httpServletResponse, violation);
                    throw new BreakChainException("Chain broken due to fatal violation");
                }
                if (!violation.getSeverity().equals(Severity.CONTINUE)) continue;
                violationList.add(violation);
            }
        }
    }

    private void checkMissingParameters(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, ViolationList violationList) throws BreakChainException {
        String string = null;
        String string2 = null;
        Rule rule = null;
        LinkedList linkedList = null;
        Iterator iterator = null;
        Violation violation = null;
        string = mutableHttpRequest.getRequestURI();
        linkedList = set.getParameterRules(string);
        if (linkedList != null) {
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                rule = (Rule)iterator.next();
                string2 = rule.getName();
                if (string2.equals("STINGER_ALL") || mutableHttpRequest.getParameter(string2) != null && !mutableHttpRequest.getParameter(string2).equals("")) continue;
                violation = new Violation(rule.getMissing(), string2, null, rule.getPattern(), string);
                if (debug) {
                    System.out.println("[Stinger-Filter] VIOLATION: Parameter " + string2 + " is missing");
                }
                if (violation.getSeverity().equals(Severity.FATAL)) {
                    this.handleViolationActions(mutableHttpRequest, httpServletResponse, violation);
                    throw new BreakChainException("Chain broken due to fatal violation");
                }
                if (!violation.getSeverity().equals(Severity.CONTINUE)) continue;
                violationList.add(violation);
            }
        } else if (debug) {
            System.out.println("[Stinger-Filter] Warning: There exists no rules for the uri " + string);
        }
    }

    private void checkMalformedParameters(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, ViolationList violationList) throws BreakChainException {
        String string = null;
        String string2 = null;
        String[] stringArray = null;
        Rule rule = null;
        Enumeration enumeration = null;
        Violation violation = null;
        string = mutableHttpRequest.getRequestURI();
        enumeration = mutableHttpRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            stringArray = mutableHttpRequest.getParameterValues(string2);
            rule = set.getParameterRule(string, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (rule == null || rule.isValid(string3)) continue;
                violation = new Violation(rule.getMalformed(), string2, string3, rule.getPattern(), string);
                if (debug) {
                    System.out.println("[Stinger-Filter] VIOLATION: Parameter " + string2 + " is malformed");
                }
                if (violation.getSeverity().equals(Severity.FATAL)) {
                    this.handleViolationActions(mutableHttpRequest, httpServletResponse, violation);
                    throw new BreakChainException("Chain broken due to fatal violation");
                }
                if (!violation.getSeverity().equals(Severity.CONTINUE)) continue;
                violationList.add(violation);
            }
        }
    }

    private void checkMalformedUri(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse, ViolationList violationList) throws BreakChainException {
        String string = null;
        String string2 = null;
        Object var6_6 = null;
        Rule rule = null;
        Object var8_8 = null;
        Violation violation = null;
        string = mutableHttpRequest.getRequestURI();
        rule = set.getParameterRule(string, "uri");
        System.out.println("Checking uri: " + string);
        String string3 = new String(mutableHttpRequest.getRequestURL());
        if (rule != null && !rule.isValid(string3)) {
            violation = new Violation(rule.getMalformed(), string2, string3, rule.getPattern(), string);
            if (debug) {
                System.out.println("[Stinger-Filter] VIOLATION: Parameter " + string2 + " is malformed");
            }
            if (violation.getSeverity().equals(Severity.FATAL)) {
                this.handleViolationActions(mutableHttpRequest, httpServletResponse, violation);
                throw new BreakChainException("Chain broken due to fatal violation");
            }
            if (violation.getSeverity().equals(Severity.CONTINUE)) {
                violationList.add(violation);
            }
        }
    }

    public void validate(MutableHttpRequest mutableHttpRequest, HttpServletResponse httpServletResponse) throws BreakChainException {
        ViolationList violationList = new ViolationList();
        violationList = new ViolationList();
        this.checkMalformedUri(mutableHttpRequest, httpServletResponse, violationList);
        this.checkMissingCookies(mutableHttpRequest, httpServletResponse, violationList);
        this.checkMalformedCookies(mutableHttpRequest, httpServletResponse, violationList);
        this.checkMissingParameters(mutableHttpRequest, httpServletResponse, violationList);
        this.checkMalformedParameters(mutableHttpRequest, httpServletResponse, violationList);
        if (debug) {
            System.out.println("Now handle any stinger violations");
        }
        this.handleViolations(mutableHttpRequest, httpServletResponse, violationList);
    }
}

